using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Cioina;


namespace Calc
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>	
	
	public class Form1 : System.Windows.Forms.Form
	{
		private static Random Rnd=new Random();
		private static TUserFunction UserFunc1= new TUserFunction(MyE);
		private static TUserFunction UserFunc2= new TUserFunction(MySqrt);
		private static TUserFunction UserFunc3= new TUserFunction(MySum);
		private static TUserFunction UserFunc4= new TUserFunction(MyRandom);
		private ushort Saved8087CW;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox textBox2;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox textBox3;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.TextBox textBox4;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button button5;
		private System.Windows.Forms.TextBox textBox5;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		
		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			//
			// TODO: Add any ructor code after InitializeComponent call
			//
		}
		private static double MyE( int ParamCount )
		{			
			return (Math.E);
		}
		private static double MySqrt( int ParamCount )
		{
			return (Math.Sqrt(CioinaEval.Prm(0)));
		}
		private static double MySum( int ParamCount )
		{
			int i;
			double s=0;
			for(i=0;i<ParamCount;i++)s+=CioinaEval.Prm(i);
			return (s);
		}
		private static double MyRandom( int ParamCount )
		{ 
			return (Rnd.NextDouble());			
		}

		protected void ParseErrorMessage(int Item)
		{
			string  s,s1,s2,pc="";
			int i;
			CioinaEval.GetErrorMessageInfo(Item,ref pc);
			s1=pc;
			i=s1.IndexOf(':',1)+1;
			if(i>1) s2=" : ";else s2="";
			for (;i<s1.Length;i++)s2+=s1[i];
			s1=s2;

			s="";
			switch ( CioinaEval.GetMathException(Item) )
			{
				case CioinaEval.EX_NONMATH:s=" : NONMATH";break;
				case CioinaEval.EX_Overflow:s=" : Overflow";break;
				case CioinaEval.EX_Underflow:s=" : Underflow";break;
				case CioinaEval.EX_InvalidArgument:s=" : InvalidArgument";break;
				case CioinaEval.EX_ZeroDivide:s=" : ZeroDivide";break;
				case CioinaEval.EX_InvalidOp:s=" : InvalidOp";break;
			}

			switch (CioinaEval.GetErrorNumber(Item))
			{
				case CioinaEval.ERR_PARSE:                                   textBox3.Text=("Invalid expression"+s1);break;
				case CioinaEval.ERR_BAD_SYNTAX:                              textBox3.Text=("Syntax error"+s1);break;
				case CioinaEval.ERR_COMMA_SYNTAX:                            textBox3.Text=("Comma syntax error"+s1);break;
				case CioinaEval.ERR_NO_MATH_EXPRESSION_WAS_PARSED:           textBox3.Text=("No math expression was parsed");break;
				case CioinaEval.ERR_PARANTHESES_SYNTAX_ERROR:                textBox3.Text=("Mismatched parenthesis");break;
				case CioinaEval.ERR_INVALID_DERIVATIVE_VARIABLE_NAME:        textBox3.Text=("Invalid name of derivative variable"+s1);break;
				case CioinaEval.ERR_MATH_EXPRESSION_IS_EMPTY:                textBox3.Text=("Mathematical expression is empty");break;
				case CioinaEval.ERR_IDENTIFIER_CANNOT_BE_EMPTY:              textBox3.Text=("Identifier cannot be empty");break;
				case CioinaEval.ERR_IDENTIFIER_LENGTH:                       textBox3.Text=("Identifier length is too long"+s1);break;
				case CioinaEval.ERR_NOT_PASCAL_IDENTIFIER:                   textBox3.Text=("Invalid identifier"+s1);break;
				case CioinaEval.ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME:      textBox3.Text=("Identifier cannot be a reserved name"+s1);break;
				case CioinaEval.ERR_IDENTIFIER_ALREADY_EXISTS:               textBox3.Text=("Identifier already exists"+s1);break;
				case CioinaEval.ERR_DUBLICATING_USER_IDENTIFIER:             textBox3.Text=("Dublicating user identifier"+s1);break;
				case CioinaEval.ERR_UNKNOWN_EXPRESSION:                      textBox3.Text=("Unknown expression"+s1);break;
				case CioinaEval.ERR_UNKNOWN_FUNCTION:                        textBox3.Text=("Undefined function"+s1);break;
				case CioinaEval.ERR_UNKNOWN_VARIABLE:                        textBox3.Text=("Undefined variable"+s1);break;
				case CioinaEval.ERR_BAD_EXPONENTIAL_FORMAT:                  textBox3.Text=("Invalid exponent value"+s1);break;
				case CioinaEval.ERR_SET_OriginalMathExpressionString_FALSE:  textBox3.Text=("Set ''OriginalMathExpressionString'' to FALSE for differentiation or for Mathematica 4.1 export");break;
				case CioinaEval.ERR_MATH_EXPRESSION_WAS_ERASED:              textBox3.Text=("Mathematical expression string was erased");break;
				case CioinaEval.ERR_USE_VerifySyntaxSemanticsAndDerivation:  textBox3.Text=("Use ''VerifySyntaxSemanticsAndDerivation'' for differentiation");break;
				case CioinaEval.ERR_DERIVATIVE_EXPRESSION_WAS_ERASED:        textBox3.Text=("Derivative expression string was erased");break;
				case CioinaEval.ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT:      textBox3.Text=("Variable count and value caunt do not corespond");break;
				case CioinaEval.ERR_MATH_EXPRESSIONS_ARRAY:                  textBox3.Text=("Use ''DoVectorOfMathExpressions'' for calculate a vector of math expression");break;
				case CioinaEval.ERR_FUNCTION_NUMBER_MUST_BE_LESS:            textBox3.Text=("Function number must be less"+s1);break;
				case CioinaEval.ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL:          textBox3.Text=("Function address cannot be nil"+s1);break;
				case CioinaEval.ERR_PROTECTED_EXPRESSION:                    textBox3.Text=("Cannot set value for protected expression"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_NAME:                           textBox3.Text=("Invalid function name"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_DUBLICATING:                    textBox3.Text=("Dublicating defined function"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_IMPLEMENTING:                   textBox3.Text=("Defined function was not implimented"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_ARG_COUNT:                      textBox3.Text=("Invalid arguments number for defined function"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_ARG_NAME:                       textBox3.Text=("Invalid argument name for defined function"+s1);break;
				case CioinaEval.ERR_DEF_FUNC_ARG_DUBLICATING:                textBox3.Text=("Dublicating argument name for defined function"+s1);break;
				case CioinaEval.ERR_MULTIPLY:                                textBox3.Text=("Invalid value for *"+s1+s);break;
				case CioinaEval.ERR_DIVISION:                                if (CioinaEval.GetMathException(Item)==CioinaEval.EX_ZeroDivide) textBox3.Text=("Division by 0 ");
								                							 else textBox3.Text=("Invalid value for /"+s1+s);break;
				case CioinaEval.ERR_PLUS:                                    textBox3.Text=("Invalid value for +"+s1+s);break;
				case CioinaEval.ERR_MINUS:                                   textBox3.Text=("Invalid value for -"+s1+s);break;
				case CioinaEval.ERR_POWER:                                   textBox3.Text=("Invalid value for ^"+s1+s);break;
				case CioinaEval.ERR_EQUAL:                                   textBox3.Text=("Invalid value for ="+s1+s);break;

				default: if(CioinaEval.GetErrorNumber(Item)>=1 && CioinaEval.GetErrorNumber(Item)<=CioinaEval.GetBuiltInFunctionCount())
						 {
							 CioinaEval.GetBuiltInFunctionName(CioinaEval.GetErrorNumber(Item),ref pc);
							 s2=pc;
							 if(s=="")textBox3.Text=("Invalid number of function arguments for: "+ s2);
							 else textBox3.Text=("Invalid value for "+ s2+s1+s);
						 }
						 else
						 {
							 CioinaEval.GetErrorMessageInfo(Item,ref pc);
							 s1=pc;
							 textBox3.Text=(s1);
						 };break; 
			}

		}
		
		protected void  ExecuteErrorMessage(int Item)
		{
			string  s,s1,s2,pc="";
			int i;
			CioinaEval.GetErrorMessageInfo(Item,ref pc);
			s1=pc;
			i=s1.IndexOf(':',1)+1;
			if(i>1) s2=" : ";else s2="";
			for (;i<s1.Length;i++)s2+=s1[i];
			s1=s2;

			s="";
			switch ( CioinaEval.GetMathException(Item) )
			{
				case CioinaEval.EX_NONMATH:s=" : NONMATH";break;
				case CioinaEval.EX_Overflow:s=" : Overflow";break;
				case CioinaEval.EX_Underflow:s=" : Underflow";break;
				case CioinaEval.EX_InvalidArgument:s=" : InvalidArgument";break;
				case CioinaEval.EX_ZeroDivide:s=" : ZeroDivide";break;
				case CioinaEval.EX_InvalidOp:s=" : InvalidOp";break;
			}

			switch (CioinaEval.GetErrorNumber(Item))
			{
				case CioinaEval.ERR_NO_MATH_EXPRESSION_WAS_PARSED:           textBox3.Text=("No math expression was parsed");break;
				case CioinaEval.ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT:      textBox3.Text=("Variable count and value caunt do not corespond");break;
				case CioinaEval.ERR_MATH_EXPRESSIONS_ARRAY:                  textBox3.Text=("Use ''DoVectorOfMathExpressions'' for calculate a vector of math expression");break;
				case CioinaEval.ERR_EXECUTE:                                 textBox3.Text=("Execution error");break;
				case CioinaEval.ERR_DEF_FUNCTION_STACK_OVERFLOW:             textBox3.Text=("Stack overflow"+s1);break;
				case CioinaEval.ERR_SYSTEM_STACK_OVERFLOW:                   textBox3.Text=("Fatal error"+s1);break;
				case CioinaEval.ERR_MULTIPLY:                                textBox3.Text=("Invalid value for *"+s1+s);break;
				case CioinaEval.ERR_DIVISION:                                if (CioinaEval.GetMathException(Item)==CioinaEval.EX_ZeroDivide) textBox3.Text=("Division by 0 ");
								            								  else textBox3.Text=("Invalid value for /"+s1+s);break;
				case CioinaEval.ERR_PLUS:                                    textBox3.Text=("Invalid value for +"+s1+s);break;
				case CioinaEval.ERR_MINUS:                                   textBox3.Text=("Invalid value for -"+s1+s);break;
				case CioinaEval.ERR_POWER:                                   textBox3.Text=("Invalid value for ^"+s1+s);break;
				case CioinaEval.ERR_EQUAL:                                   textBox3.Text=("Invalid value for ="+s1+s);break;
				default: if(CioinaEval.GetErrorNumber(Item)>=1 && CioinaEval.GetErrorNumber(Item)<=CioinaEval.GetBuiltInFunctionCount())
						 {
							 CioinaEval.GetBuiltInFunctionName(CioinaEval.GetErrorNumber(Item),ref pc);
							 s2=pc;
							 if(s=="")textBox3.Text=("Invalid number of function arguments for: "+ s2);
							 else textBox3.Text=("Invalid value for "+ s2+s1+s);
						 }
						 else
						 {
							 CioinaEval.GetErrorMessageInfo(Item,ref pc);
							 s1=pc;
							 textBox3.Text=(s1);
						 };break; 
			}
		}


			/// <summary>
			/// Clean up any resources being used.
			/// </summary>
			protected override void Dispose( bool disposing )
			{
				if( disposing )
				{
					if (components != null) 
					{
						components.Dispose();
					}
				}
				base.Dispose( disposing );
			}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.panel1 = new System.Windows.Forms.Panel();
			this.label2 = new System.Windows.Forms.Label();
			this.button4 = new System.Windows.Forms.Button();
			this.textBox4 = new System.Windows.Forms.TextBox();
			this.button3 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.button1 = new System.Windows.Forms.Button();
			this.textBox2 = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.textBox3 = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.button5 = new System.Windows.Forms.Button();
			this.textBox5 = new System.Windows.Forms.TextBox();
			this.groupBox1.SuspendLayout();
			this.panel1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.textBox1});
			this.groupBox1.Dock = System.Windows.Forms.DockStyle.Top;
			this.groupBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(656, 120);
			this.groupBox1.TabIndex = 6;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Math Expression";
			// 
			// textBox1
			// 
			this.textBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.textBox1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.textBox1.Location = new System.Drawing.Point(3, 22);
			this.textBox1.Multiline = true;
			this.textBox1.Name = "textBox1";
			this.textBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox1.Size = new System.Drawing.Size(650, 95);
			this.textBox1.TabIndex = 0;
			this.textBox1.Text = "Sin(x)";
			this.textBox1.TextChanged += new System.EventHandler(this.textBox1_TextChanged);
			// 
			// splitter1
			// 
			this.splitter1.Dock = System.Windows.Forms.DockStyle.Top;
			this.splitter1.Location = new System.Drawing.Point(0, 120);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(656, 3);
			this.splitter1.TabIndex = 7;
			this.splitter1.TabStop = false;
			// 
			// panel1
			// 
			this.panel1.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.textBox5,
																				 this.button5,
																				 this.label3,
																				 this.label2,
																				 this.button4,
																				 this.textBox4,
																				 this.button3,
																				 this.button2,
																				 this.button1,
																				 this.textBox2,
																				 this.label1});
			this.panel1.Dock = System.Windows.Forms.DockStyle.Top;
			this.panel1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.panel1.Location = new System.Drawing.Point(0, 123);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(656, 109);
			this.panel1.TabIndex = 9;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 64);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(64, 16);
			this.label2.TabIndex = 7;
			this.label2.Text = "Diff Var";
			// 
			// button4
			// 
			this.button4.Location = new System.Drawing.Point(138, 63);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(136, 32);
			this.button4.TabIndex = 6;
			this.button4.Text = "&Differentiate";
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// textBox4
			// 
			this.textBox4.Location = new System.Drawing.Point(72, 64);
			this.textBox4.Name = "textBox4";
			this.textBox4.Size = new System.Drawing.Size(56, 26);
			this.textBox4.TabIndex = 5;
			this.textBox4.Text = "x";
			// 
			// button3
			// 
			this.button3.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.button3.Location = new System.Drawing.Point(416, 16);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(88, 32);
			this.button3.TabIndex = 4;
			this.button3.Text = "&Built-In";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button2
			// 
			this.button2.Location = new System.Drawing.Point(528, 16);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(88, 32);
			this.button2.TabIndex = 3;
			this.button2.Text = "&Help";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button1
			// 
			this.button1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.button1.Location = new System.Drawing.Point(304, 16);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(88, 32);
			this.button1.TabIndex = 2;
			this.button1.Text = "&Execute";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// textBox2
			// 
			this.textBox2.BackColor = System.Drawing.SystemColors.Info;
			this.textBox2.BorderStyle = System.Windows.Forms.BorderStyle.None;
			this.textBox2.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.textBox2.Location = new System.Drawing.Point(64, 17);
			this.textBox2.Name = "textBox2";
			this.textBox2.Size = new System.Drawing.Size(216, 19);
			this.textBox2.TabIndex = 1;
			this.textBox2.Text = "";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(56, 23);
			this.label1.TabIndex = 0;
			this.label1.Text = "Result:";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.textBox3});
			this.groupBox2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.groupBox2.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(204)));
			this.groupBox2.Location = new System.Drawing.Point(0, 232);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(656, 214);
			this.groupBox2.TabIndex = 10;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Info";
			// 
			// textBox3
			// 
			this.textBox3.Dock = System.Windows.Forms.DockStyle.Fill;
			this.textBox3.Location = new System.Drawing.Point(3, 22);
			this.textBox3.Multiline = true;
			this.textBox3.Name = "textBox3";
			this.textBox3.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.textBox3.Size = new System.Drawing.Size(650, 189);
			this.textBox3.TabIndex = 0;
			this.textBox3.Text = "";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(288, 68);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(160, 24);
			this.label3.TabIndex = 9;
			this.label3.Text = "Loop count from 1 to";
			// 
			// button5
			// 
			this.button5.Location = new System.Drawing.Point(528, 64);
			this.button5.Name = "button5";
			this.button5.Size = new System.Drawing.Size(88, 32);
			this.button5.TabIndex = 10;
			this.button5.Text = "&Speed";
			this.button5.Click += new System.EventHandler(this.button5_Click);
			// 
			// textBox5
			// 
			this.textBox5.Location = new System.Drawing.Point(449, 64);
			this.textBox5.Name = "textBox5";
			this.textBox5.Size = new System.Drawing.Size(71, 26);
			this.textBox5.TabIndex = 11;
			this.textBox5.Text = "100000";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(656, 446);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.groupBox2,
																		  this.panel1,
																		  this.splitter1,
																		  this.groupBox1});
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.Closed += new System.EventHandler(this.Form1_Closed);
			this.groupBox1.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			string s="";
            Saved8087CW=CioinaEval.GetFPU8087CW();
  			CioinaEval.SetFPU8087CW(4978) ;
			//CioinaEval.SetFPU8087CW(4927);
			CioinaEval.AddUserFunction("MyE",UserFunc1,0);
			CioinaEval.AddUserFunction("MySqrt",UserFunc2,1);
			CioinaEval.AddUserFunction("MySum",UserFunc3,CioinaEval.MaxParamCount);
			CioinaEval.AddUserFunction("MyRandom",UserFunc4,-1);
		
			CioinaEval.CreateList();
			CioinaEval.AddMathExpressionWithUserFunctions();
            CioinaEval.AddSharedVar("x",0,1);
			CioinaEval.GetVersionInfo(ref s);
			Text = s;
			CioinaEval.GetOwnerInfo(ref s);
			Text = Text+"   "+s;
		}

		private void Form1_Closed(object sender, System.EventArgs e)
		{
			CioinaEval.FreeAll();
			CioinaEval.SetFPU8087CW(Saved8087CW) ;
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			double d;
            textBox3.Text="";  
			CioinaEval.ParseWithSharedVar(0,textBox1.Text,0);
			if (CioinaEval.GetErrorFlag(0)!=0)ParseErrorMessage(0);
			d=CioinaEval.DoMathExpression(0);
			textBox2.Text = d.ToString();

		}

		private void textBox1_TextChanged(object sender, System.EventArgs e)
		{
		textBox3.Text="";
		textBox2.Text=""; 
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			int i;
			string pc="";
			textBox3.Text = "";
			for(i=0;i<=CioinaEval.GetTotalFunctionCount(0);i++)
			{
				CioinaEval.GetBuiltInFunctionInfo(0,i,ref pc);
				textBox3.Text += i.ToString()+".  " +pc + Environment.NewLine;
			}

		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			int i;
			string pc="";
			textBox3.Text = "";
			for(i=1;i<=CioinaEval.GetBuiltInFunctionCount();i++)
			{
				CioinaEval.GetBuiltInFunctionName(i,ref pc);
				textBox3.Text += i.ToString()+".  " +pc + Environment.NewLine;
			}

		}

		private void button4_Click(object sender, System.EventArgs e)
		{
			string pc="";
			textBox3.Text = "";
			CioinaEval.ParseAndDifferentiate(0,textBox1.Text,"",textBox4.Text,1);
            if (CioinaEval.GetErrorFlag(0)!=0)ParseErrorMessage(0);	
			else
			{
				CioinaEval.GetDerivativeExpressionString(0,ref pc);
				textBox3.Text=pc;
			}

		}

		private void button5_Click(object sender, System.EventArgs e)
		{
			double d;
			int i,t,n=0;
			try
			{
				n = Convert.ToInt32(textBox5.Text);
			}
			catch(System.FormatException)
			{
				MessageBox.Show("Invalid integer: "+textBox5.Text);
			}

			textBox3.Text="";  
			textBox2.Text="";  
			CioinaEval.ParseWithSharedVar(0,textBox1.Text,0);
			if (CioinaEval.GetErrorFlag(0)!=0)ParseErrorMessage(0);
			else
			{
				t = Environment.TickCount;
				d=0;
				for(i=1; i<=n; i++)
				{  
					CioinaEval.SetVariableValue(0,1,1.0/i); 
					d+=CioinaEval.DoMathExpression(0);
					if (CioinaEval.GetErrorFlag(0)!=0)
					{
						ParseErrorMessage(0);
						break;
					}
				}
				t = Environment.TickCount-t;
			    textBox2.Text = d.ToString();		
				if (i>n)textBox3.Text="Loop executing time = "+t.ToString()+" msec.";
		    }
		}
	
	}
}
